#!/bin/sh --noprofile

# Message our PPID to the parent so we can wait for it.
echo "PID: $$"

TOOL_NAME="$1"
SOURCE_DIR="$2"
LINK_DIR="$3"
OUTPUT=""

if [ ! -e "$SOURCE_DIR/$TOOL_NAME" ]; then
	echo "\"$TOOL_NAME\" could not be located in \"$SOURCE_DIR\""
	exit 1
fi

# echo "Linking \"$TOOL_NAME\" from \"$SOURCE_DIR\" to \"$LINK_DIR\":"

if (/bin/mkdir -p "$LINK_DIR" 2>&1 && /bin/ln -s "$SOURCE_DIR/$TOOL_NAME" "$LINK_DIR/$TOOL_NAME" 2>&1); then
	echo "Link to \"$TOOL_NAME\" successfully created in \"$LINK_DIR\""
	exit 0
fi

exit 4
